/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai.target;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobTerrestrial;
import untamedwilds.entity.ISpecies;

public class AngrySleeperTarget<T extends LivingEntity>
extends TargetGoal {
    protected final Class<T> targetClass;
    protected final int targetChance;
    protected LivingEntity target;
    protected ComplexMobTerrestrial taskOwner;
    protected Predicate<T> targetEntitySelector;
    private int runningTicks;

    public AngrySleeperTarget(ComplexMobTerrestrial entityIn, Class<T> targetClassIn, boolean checkSight) {
        this(entityIn, targetClassIn, checkSight, false);
    }

    public AngrySleeperTarget(ComplexMobTerrestrial entityIn, Class<T> targetClassIn, boolean checkSight, boolean nearbyOnlyIn) {
        this(entityIn, targetClassIn, 4, checkSight, nearbyOnlyIn);
    }

    public AngrySleeperTarget(ComplexMobTerrestrial entityIn, Class<T> targetClassIn, int targetChanceIn, boolean checkSight, boolean nearbyOnlyIn) {
        super((Mob)entityIn, checkSight, nearbyOnlyIn);
        this.targetClass = targetClassIn;
        this.targetChance = targetChanceIn;
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        this.runningTicks = 1000;
        this.taskOwner = entityIn;
        this.targetEntitySelector = entity -> {
            Player player;
            if (entity instanceof Creeper || ComplexMob.getEcoLevel((LivingEntity)this.taskOwner) > ComplexMob.getEcoLevel(entity) * 2) {
                return false;
            }
            if (((Object)((Object)this.taskOwner)).getClass() == entity.getClass() && this.taskOwner instanceof ISpecies && entity instanceof ISpecies) {
                ComplexMobTerrestrial attacker = this.taskOwner;
                ComplexMob defender = (ComplexMob)((Object)entity);
                if (attacker.getVariant() == defender.getVariant()) {
                    return false;
                }
            }
            if (entity instanceof Player && ((player = (Player)entity).m_20161_() || player.m_7500_() || player.m_5833_())) {
                return false;
            }
            return TargetingConditions.m_148352_().m_26885_((LivingEntity)this.taskOwner, entity) && this.m_26150_((LivingEntity)entity, TargetingConditions.f_26872_);
        };
    }

    public boolean m_8036_() {
        if (!((Boolean)ConfigGamerules.angrySleepers.get()).booleanValue() || !this.taskOwner.m_5803_() || this.taskOwner.m_21824_() || this.taskOwner.forceSleep != 0) {
            return false;
        }
        List list = this.f_26135_.f_19853_.m_6443_(LivingEntity.class, this.f_26135_.m_142469_().m_82377_(6.0, 4.0, 6.0), input -> this.targetEntitySelector.test((LivingEntity)input));
        if (!list.isEmpty()) {
            LivingEntity player = (LivingEntity)list.get(0);
            this.taskOwner.setSleeping(false);
            this.target = player;
        }
        return true;
    }

    public void m_8056_() {
        this.taskOwner.m_6710_(this.target);
        this.taskOwner.forceSleep = -300;
        super.m_8056_();
    }

    public boolean m_8045_() {
        --this.runningTicks;
        if (this.runningTicks < 1) {
            return false;
        }
        return super.m_8045_();
    }
}

